import { NextRequest, NextResponse } from 'next/server';
import { openDB } from '@/src/lib/db';

// DELETE /api/tasks/recordings/[recordingId] - Delete a recording
export async function DELETE(
    request: NextRequest,
    { params }: { params: { recordingId: string } }
) {
    try {
        const recordingId = parseInt(params.recordingId);
        const db = await openDB();

        await new Promise((resolve, reject) => {
            db.run(`
                DELETE FROM task_recordings
                WHERE id = ?
            `, [recordingId], (err) => {
                if (err) {
                    reject(err);
                } else {
                    resolve(null);
                }
            });
        });

        return NextResponse.json({ success: true });
    } catch (error) {
        console.error('Error deleting recording:', error);
        return NextResponse.json({ error: 'Failed to delete recording' }, { status: 500 });
    }
}






